/**
 * 
 */
package gov.va.genisis2Test.boImp;

import static org.mockito.Mockito.when;

import java.util.ArrayList;
import java.util.List;

import org.activiti.engine.ProcessEngine;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mock;
import org.slf4j.LoggerFactory;

import gov.va.genisis2.bo.ActivitiService;
import gov.va.genisis2.bo.BusinessService;
import gov.va.genisis2.common.enums.CommonEnum;
import gov.va.genisis2.model.CommentHistory;
import gov.va.genisis2.model.Request;
import gov.va.genisis2.model.RequestType;
import gov.va.genisis2.model.Source;
import gov.va.genisis2.model.StudyApproval;
import gov.va.genisis2.model.Users;
import gov.va.genisis2.service.impl.CommentHistoryService;
import gov.va.genisis2.service.impl.LookUpService;
import gov.va.genisis2.service.impl.RequestService;
import gov.va.genisis2.service.impl.StudyApprovalService;
import gov.va.genisis2.service.impl.UserManagementService;
import gov.va.genisis2.util.rest.helper.ResponseWrapper;
import gov.va.genisis2.vo.CopyTableDomains;
import gov.va.genisis2.vo.CopyTableSource;
import gov.va.genisis2.vo.EmailDetails;
import gov.va.genisis2.vo.GenisisProperties;
import gov.va.genisis2Test.abstractClass.AbstractMockMvcTests;
import gov.va.genisis2Test.util.Helper;

/**
 * @author Getaneh Kassahun
 *
 */
public class BusinessServiceTest extends AbstractMockMvcTests {

	/** The logger. */
	private final org.slf4j.Logger logger = LoggerFactory.getLogger(BusinessServiceTest.class);

	// Get services
	private BusinessService businesService = new BusinessService();

	/**
	 * Test Business Service.
	 * 
	 * 
	 */

	@Test
	public void testBusinessService() {
		logger.info("**********Junit Test Busines servicess**********");

		getBusinessServiceUtil();

		CopyTableSource copyTableSource =	new CopyTableSource("tableNameTest", "tcSourceDataBaseServerNameTest",
				"tcSourceDataBaseNameTest", "sourceSchemaNameTest", "tcDestinationDataBaseServerNameTest",
				"tcDestinationDataBaseUserNameTest", "tcDestinationDataBaseUserPasswordTest",
				"tcDestinationServerDataBaseNameTest", "destinationSchemaNameTest",
				"tcManagementDataBaseServerNameTest", "tcManagementDataBaseUserNameTest",
				"tcManagementDataBaseUserPasswordTest", "tcManagementDataBaseSchemaTest", "cmdFilePathTest",
				"tcManagementDataBaseNameTest", "tcTemporaryDataBaseNameTest");
		StudyApproval studyApproval = Helper.getNewStudyApproval();
		Request request = Helper.getExistingRequest();

		Assert.assertNotNull(businesService.createStudyApproval(studyApproval));

		Assert.assertNotNull(businesService.updateStudyApproval(studyApproval));

		Assert.assertNotNull(businesService.getStudyApprovalsByID(1));

		Assert.assertNotNull(businesService.getStudyApprovalsByUID("createdBy"));

		Assert.assertNotNull(businesService.getStudyApprovals());

		Assert.assertNotNull(businesService.getRequestByID(request.getId()));

		Assert.assertNotNull(businesService.getRequestDataSources());

		Assert.assertNotNull(businesService.getRequestTypes());

		Assert.assertNotNull(businesService.getAllRequests());

		Assert.assertNotNull(businesService.getAllRequestsByStaus("status"));

		Assert.assertNotNull(businesService.getRequestsByDataManagers("userId"));

		Assert.assertNotNull(businesService.getRequestsDataSourceManagers("userId"));

		Assert.assertNotNull(businesService.getRequestsByUID("userId"));

		Assert.assertNotNull(businesService.getUserDetailsByEmail("emailId@gmail.com"));

		Assert.assertNotNull(businesService.getUserDetailsById(1));

		Assert.assertNotNull(businesService.getUserRole(1));

		Assert.assertNotNull(businesService.getRequestTrackingByID(1));

		Assert.assertNotNull(businesService.getAllRequestsByStudyApproval(1));

		Assert.assertNotNull(businesService.getCopyTableDomains());
		
		Assert.assertNotNull(businesService.getGenisisProperties());
		
		Assert.assertNotNull(businesService.getCopyTableSource());
		
		Assert.assertNotNull(businesService.performTableCopyTransfer(new CopyTableSource(), 1));
		
		Assert.assertNotNull(businesService.getActivitiService()); 
		
		Assert.assertNotNull(businesService.getCommentHistoryService()); 	
		
		Assert.assertNotNull(businesService.getUserManagementService());
		
		//Assert.assertNotNull(businesService.createCommentHistory(Helper.getCommentHistory()));

		// Assert.assertNotNull(businesService.submitOrModify(request));

		// Assert.assertNotNull(businesService.createRequest(request));

		logger.info("**********End Junit Test Busisnes Service**********");
	}

	/**
	 * Test Persist.
	 * 
	 * 
	 */
	@Test
	public void testPersist() {

		Request request = Helper.getExistingRequest();

		getPersistUtil();

		Assert.assertNotNull(businesService.persist(1, request, "Update"));
		Assert.assertNotNull(businesService.persist(1, request, "Submitted"));

	}

	private void getPersistUtil() {

		RequestService requestService = getMockRequestService();
		requestService.setRequestDao(getMockRequestDao());
		businesService.setRequestService(requestService);
	}

	private void getBusinessServiceUtil() {

		CopyTableSource copyTableSource = new CopyTableSource("tableNameTest", "tcSourceDataBaseServerNameTest",
				"tcSourceDataBaseNameTest", "sourceSchemaNameTest", "tcDestinationDataBaseServerNameTest",
				"tcDestinationDataBaseUserNameTest", "tcDestinationDataBaseUserPasswordTest",
				"tcDestinationServerDataBaseNameTest", "destinationSchemaNameTest",
				"tcManagementDataBaseServerNameTest", "tcManagementDataBaseUserNameTest",
				"tcManagementDataBaseUserPasswordTest", "tcManagementDataBaseSchemaTest", "cmdFilePathTest",
				"tcManagementDataBaseNameTest", "tcTemporaryDataBaseNameTest");

		CopyTableDomains copyTableDomains = new CopyTableDomains("sourceDBNameTestOne", "destinationDBNameTestOne",
				"sourceDBServerNameTestOne", "destinationDBServerNameTestOne", "sUsernameTestOne", "dUsernameTestOne");
		
		GenisisProperties genisisProperties = new GenisisProperties("datasourcemanagers");

		StudyApprovalService studyApprovalService = getMockStudyApprovalService();
		RequestService requestService = getMockRequestService();
		UserManagementService userManagementService = getMockUserManagementService();
		ActivitiService activitiService = getMockActivitiService();
		CommentHistoryService commentHistoryService = getMockCommentHistoryService();
		LookUpService lookUpService = new LookUpService();
		

		// Inject DAO into service classes
		requestService.setRequestDao(getMockRequestDao());
		studyApprovalService.setStudyApprovalDao(getMockStudyApprovalDao());
		userManagementService.setUserManagementDAO(getMockUserManagementDao());
		lookUpService.setLookUpDao(getMockLookUpDao());

		businesService.setStudyApprovalService(studyApprovalService);
		businesService.setRequestService(requestService);
		businesService.setUserManagementService(userManagementService);
		businesService.setActivitiService(activitiService);
		businesService.setCopyTableDomains(copyTableDomains);
		businesService.setCopyTableSource(copyTableSource);
		businesService.getCopyTableSource(copyTableSource);
		businesService.setGenisisProperties(genisisProperties);
		businesService.setLookUpService(lookUpService);
		businesService.setCommentHistoryService(commentHistoryService);

		// Get studyApproval, request, source, requestType, commentHistory
		// object

		Request request = Helper.getExistingRequest();
		Source source = Helper.getNewSource();
		RequestType requestType = Helper.getNewRequestType();
		CommentHistory commentHistory = Helper.getCommentHistory();
		StudyApproval studyApproval = Helper.getNewStudyApproval();
		

		// Save studyApproval, request, source, requestType, commentHistory
		getMockHibernateTemplate().save(studyApproval);
		getMockHibernateTemplate().save(request);
		getMockHibernateTemplate().save(source);
		getMockHibernateTemplate().save(requestType);
		getMockHibernateTemplate().save(commentHistory);
	}

}
